/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import mcinterface1122.IBuilderItemInterface;
import mcinterface1122.WrapperNBT;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class WrapperItemStack
implements IWrapperItemStack {
    private static final TileEntityFurnace VANILLA_FAKE_FURNACE = new TileEntityFurnace();
    protected final ItemStack stack;

    protected WrapperItemStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean isCompleteMatch(IWrapperItemStack other) {
        ItemStack otherStack = ((WrapperItemStack)other).stack;
        return otherStack.func_77969_a(this.stack) && (otherStack.func_77942_o() ? otherStack.func_77978_p().equals((Object)this.stack.func_77978_p()) : !this.stack.func_77942_o());
    }

    @Override
    public int getFurnaceFuelValue() {
        return TileEntityFurnace.func_145952_a((ItemStack)this.stack);
    }

    @Override
    public IWrapperItemStack getSmeltedItem(AWrapperWorld world) {
        return new WrapperItemStack(FurnaceRecipes.func_77602_a().func_151395_a(this.stack).func_77946_l());
    }

    @Override
    public int getSmeltingTime(AWrapperWorld world) {
        return VANILLA_FAKE_FURNACE.func_174904_a(this.stack);
    }

    @Override
    public boolean isBrewingFuel() {
        return this.stack.func_77973_b() == Items.field_151065_br;
    }

    @Override
    public boolean isBrewingVessel() {
        return BrewingRecipeRegistry.isValidInput((ItemStack)this.stack);
    }

    @Override
    public boolean isBrewingModifier() {
        return BrewingRecipeRegistry.isValidIngredient((ItemStack)this.stack);
    }

    @Override
    public IWrapperItemStack getBrewedItem(IWrapperItemStack modifierStack) {
        return new WrapperItemStack(BrewingRecipeRegistry.getOutput((ItemStack)this.stack, (ItemStack)((WrapperItemStack)modifierStack).stack).func_77946_l());
    }

    @Override
    public AItemBase getItem() {
        Item item = this.stack.func_77973_b();
        return item instanceof IBuilderItemInterface ? ((IBuilderItemInterface)item).getItem() : null;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    @Override
    public int getSize() {
        return this.stack.func_190916_E();
    }

    @Override
    public int getMaxSize() {
        return this.stack.func_77976_d();
    }

    @Override
    public int add(int qty) {
        if (qty < 0) {
            int amountToRemove = -qty;
            if (amountToRemove > this.getSize()) {
                amountToRemove = this.getSize();
            }
            this.stack.func_190920_e(this.stack.func_190916_E() - amountToRemove);
            return qty + amountToRemove;
        }
        int amountToAdd = qty;
        if (amountToAdd + this.getSize() > this.getMaxSize()) {
            amountToAdd = this.getMaxSize() - this.getSize();
        }
        this.stack.func_190920_e(this.stack.func_190916_E() + amountToAdd);
        return qty - amountToAdd;
    }

    @Override
    public IWrapperItemStack copy() {
        return new WrapperItemStack(this.stack.func_77946_l());
    }

    @Override
    public IWrapperItemStack split(int qty) {
        return new WrapperItemStack(this.stack.func_77979_a(qty));
    }

    @Override
    public boolean interactWith(EntityFluidTank tank, IWrapperPlayer player) {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null) {
            FluidStack drainedStack = handler.drain(Integer.MAX_VALUE, false);
            if (drainedStack != null && drainedStack.amount > 0) {
                int amountToDrain = (int)tank.fill(drainedStack.getFluid().getName(), "wildcard", drainedStack.amount, false);
                if ((drainedStack = handler.drain(amountToDrain, !player.isCreative())) != null) {
                    tank.fill(drainedStack.getFluid().getName(), "wildcard", drainedStack.amount, true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            } else {
                FluidStack containedStack = FluidRegistry.getFluidStack((String)tank.getFluid(), (int)((int)tank.getFluidLevel()));
                int amountFilled = handler.fill(containedStack, !player.isCreative());
                if (amountFilled > 0) {
                    tank.drain(tank.getFluid(), "wildcard", amountFilled, true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IWrapperNBT getData() {
        return this.stack.func_77942_o() ? new WrapperNBT(this.stack.func_77978_p().func_74737_b()) : null;
    }

    @Override
    public void setData(IWrapperNBT data) {
        this.stack.func_77982_d(data != null ? ((WrapperNBT)data).tag : null);
    }
}

